/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
:: Serial Driver Source Code                                             
:: (C) 1997-2009 Woodward
:: All rights reserved
::                                                              
::-----------------------------------------------------------------------------------------------------------
:: Header Module
:: EriLTble.h
::
:: Description: 
::  Contains structures for ERI dim table and map table
::
::                                                                                                      
:: $Archive:: /Controllers/Engine Controller/PCM555/Software/Protocols/Include/ERILongTable.h               $
:: $Author ::                                                                                               $
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

#ifndef __ERILTBLE_H
#define __ERILTBLE_H

/* --- INCLUDE FILES ----------------------------------------------------------------------------------------*/
#include <typedefn.h>

#ifdef __ERI_INDIRECT_REQ

/* --- DEFINES ----------------------------------------------------------------------------------------------*/
#define CLEAR_ERR_KEY   199


/* --- TYPEDEF ----------------------------------------------------------------------------------------------*/
#pragma pack(1)

typedef struct 
{
    const void *AddressPtr;                   /* Item  0   is         Address*/
    const void *BitItems[20];                 /* Items 1   to 20 are  bit items*/
    const void *Items[179];                   /* Items 21  to 199 are gen items*/
    const void *MapStart;                     /* Item  200 points to ptr to Maps*/
} S_EriLongTbl;

typedef union 
{
    S_EriLongTbl Structure;
    void *Array[201];
} U_EriLongTbl;

#pragma pack()

/* --- GLOBAL VARIABLE EXTERN -------------------------------------------------------------------------------*/
extern const U_EriLongTbl EriLongTbl;

/* --- FUNCTION PROTOTYPES ----------------------------------------------------------------------------------*/

#endif /* __ERI_INDIRECT_REQ */

#endif /* __ERILTBLE_H*/

/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::                                          Change Log                                                      :
::----------------------------------------------------------------------------------------------------------:
::                                       Model Year 2001                                                    :
::                                                                                                          :
:: Version  User    Date       SCR#                             Description                                 :
::----------------------------------------------------------------------------------------------------------:
:: 1        SMB     12/08/1998                                  Ported from CPU32 SCI
:: 2		REH		12/16/1998									Changed comment style
::*/
